<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/login', 'Auth::login');
$routes->post('/login', 'Auth::attemptLogin');
$routes->get('/logout', 'Auth::logout');
$routes->get('/', 'Home::index');
$routes->get('/aktivitas', 'Aktivitas::frontend');
$routes->get('/pendidikan', 'Pendidikan::frontend');
$routes->get('/biodata', 'Biodata::frontend');
// ===================== BACKEND / AUTH ADMIN =====================
$routes->group('auth', ['filter' => 'auth'], function($routes) {

    $routes->get('dashboard', 'Auth::dashboard');
    $routes->get('manage', 'Auth::index');

    // CRUD Admin
    $routes->get('/', 'Auth::index');
    $routes->get('create', 'Auth::create');
    $routes->post('store', 'Auth::store');
    $routes->get('edit/(:num)', 'Auth::edit/$1');
    $routes->post('update/(:num)', 'Auth::update/$1');
    $routes->get('delete/(:num)', 'Auth::delete/$1');

    // Biodata
    $routes->get('biodata', 'Biodata::index');
    $routes->get('biodata/create', 'Biodata::create');
    $routes->post('biodata/store', 'Biodata::store');
    $routes->get('biodata/edit/(:num)', 'Biodata::edit/$1');
    $routes->post('biodata/update/(:num)', 'Biodata::update/$1');
    $routes->get('biodata/delete/(:num)', 'Biodata::delete/$1');

    // Pendidikan
    $routes->get('pendidikan', 'Pendidikan::index');
    $routes->get('pendidikan/create', 'Pendidikan::create');
    $routes->post('pendidikan/store', 'Pendidikan::store');
    $routes->get('pendidikan/edit/(:num)', 'Pendidikan::edit/$1');
    $routes->post('pendidikan/update/(:num)', 'Pendidikan::update/$1');
    $routes->get('pendidikan/delete/(:num)', 'Pendidikan::delete/$1');

    // Aktivitas
    $routes->get('aktivitas', 'Aktivitas::index');
    $routes->get('aktivitas/create', 'Aktivitas::create');
    $routes->post('aktivitas/store', 'Aktivitas::store');
    $routes->get('aktivitas/edit/(:num)', 'Aktivitas::edit/$1');
    $routes->post('aktivitas/update/(:num)', 'Aktivitas::update/$1');
    $routes->get('aktivitas/delete/(:num)', 'Aktivitas::delete/$1');
});

// ================= UTIL =================
$routes->get('cektabel', 'CekTabel::index');
